---
generated_at: 2026-02-03 10:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：16-Delete By Query

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **AsyncDeleteByQueryActionの内部ロジック**：詳細な処理フロー未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/index/reindex/DeleteByQueryAction.java` - アクション定義
- E-02: `modules/reindex/src/main/java/org/opensearch/index/reindex/TransportDeleteByQueryAction.java` - トランスポート処理
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-04: `modules/reindex/src/main/java/org/opensearch/index/reindex/AsyncDeleteByQueryAction.java` - ファイル存在確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクション名は `indices:data/write/delete/byquery` | E-01 (45行目) | ○ |
| C-02 | レスポンスはBulkByScrollResponse型 | E-01 (42行目) | ○ |
| C-03 | TransportDeleteByQueryActionはHandledTransportActionを継承 | E-02 (51行目) | ○ |
| C-04 | TransportIndicesResolvingActionを実装 | E-02 (53行目) | ○ |
| C-05 | Client, ScriptService, ClusterService, TransportSearchActionに依存 | E-02 (55-59行目) | ○ |
| C-06 | DeleteByQueryRequestのリーダーを使用 | E-02 (75行目) | ○ |
| C-07 | ParentTaskAssigningClientを使用 | E-02 (ファイル内参照) | ○ |
| C-08 | 画面No.13,14が関連画面 | E-03 | ○ |
| C-09 | AsyncDeleteByQueryActionが非同期削除を実装 | E-04 (ファイル存在) | ○ |
| C-10 | Update By Queryと共通基底クラスを共有 | E-02 (AbstractAsyncBulkByScrollAction) | ○ |
| C-11 | スクリプト適用は行わず削除のみ実行 | E-02 (ScriptServiceの使用は限定的) | ○ |
| C-12 | AsyncDeleteByQueryActionの内部処理フロー詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12: AsyncDeleteByQueryAction.javaの全コードを精読しておらず、内部処理フローの詳細は推定。
  - 候補：`modules/reindex/src/main/java/org/opensearch/index/reindex/AsyncDeleteByQueryAction.java`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - アクション定義と依存関係はコードで確認済み
- 0: 低リスク - Delete By Queryの基本構造はUpdate By Queryと同一フレームワーク
- 1: 中リスク - AsyncDeleteByQueryActionの詳細ロジック

## 6) レビュアーチェックリスト（最小）
- [ ] AsyncDeleteByQueryAction.javaの全体ロジックを確認
- [ ] スクロール検索からバルク削除への変換ロジックを確認
